<?php

if (!defined('_PS_VERSION_'))
	exit;

class cufonsettings extends Module
{
	private $_html = '';
	private $_postErrors = array();

	function __construct()
	{
		$this->name = 'cufonsettings';
		$this->tab = 'front_office_features';
		$this->version = 1;
		$this->author = 'Prestaholic';
		$this->need_instance = 0;

		parent::__construct();

		$this->displayName = $this->l('Cufon Font Settings');
		$this->description = $this->l('Enable cufon font replacement.');
	}

	public function install()
	{
		if (!parent::install()
			OR !$this->registerHook('header') OR
			!Configuration::updateValue('CUFON_FONT', 'bebas-neue.cufonfonts.js') OR
			!Configuration::updateValue('CUFON_CONFIG', 'Cufon.replace("h1,h2,h3,h4,h5,h6", { hover: true, textShadow: "#000 1px 1px 2px" });'))
			return false;
		return true;
	}
	
	public function uninstall()
	{
		if (!Configuration::deleteByName('CUFON_FONT') OR 
		!Configuration::deleteByName('CUFON_CONFIG') OR 
		!parent::uninstall())

			return false;
		return true;
	}
	
	public function getContent()
	{
		$this->_html .=	'<h2>'.$this->displayName.'</h2>';
		if (Tools::isSubmit('submitCufon'))
		{
				Configuration::updateValue('CUFON_FONT', (Tools::getValue('cufon')));
				Configuration::updateValue('CUFON_CONFIG', (Tools::getValue('cufonconfig')));
				$this->_html .=	'<div class="conf confirm"><img src="../img/admin/ok.gif" alt="'.$this->l('Confirmation').'" />'.$this->l('Settings updated').'</div>';

		}
		$this->displayForm();
		echo $this->_html;
	}

	public function displayForm()
	{
		$this->_html .=	'<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
		<fieldset>
			<script type="text/javascript">
				var pos_select = '.(($tab = (int)Tools::getValue('tabs')) ? $tab : '0').';
			</script>
			<script src="../js/tabpane.js" type="text/javascript"></script>
			<link type="text/css" rel="stylesheet" href="../css/tabpane.css" />
			<input type="hidden" name="tabs" id="tabs" value="0" />
			<div>'.$this->l('To add cufon you have to upload cufon fonts to '._MODULE_DIR_.$this->name.'/js/fonts/').'</div><br/>
			<div class="tab-pane" id="tab-pane-1" style="width:100%;">
				<div class="tab-page" id="tab-page-1">
					<h2 class="tab">&nbsp;'.$this->l('Cufon Font Settings').'</h2>
					<label>'.$this->l('Cufon Font:').'</label>
				<div class="margin-form">
					<select name="cufon">';
		$alt_cufon_path = _PS_MODULE_DIR_ . 'cufonsettings/js/fonts/';
		$alt_cufon = array();

		if (is_dir($alt_cufon_path)) {
    		if ($alt_cufon_dir = opendir($alt_cufon_path)) {
        		while ( ($alt_cufon_file = readdir($alt_cufon_dir)) !== false ) {
            		if((stristr($alt_cufon_file, ".js") !== false)){
                		$alt_cufon[] = $alt_cufon_file;
            		}
        		}
    		}
		}
		foreach ($alt_cufon as $cufon)
			{
		$this->_html .=	'<option value="' . $cufon . '" '.(Tools::getValue('cufon', Configuration::get('CUFON_FONT')) ==  $cufon ? 'selected="selected"' : '').'>'. $cufon .'</option>';
			}
		$this->_html .=	'</select>
					<p class="clear">'.$this->l('Select the Cufon Font you want for the site').'</p>
				</div>
				<label>'.$this->l('Cufon Code:').'</label>
				<div class="margin-form">
					<textarea name="cufonconfig" rows="6" cols="100" class="rte">'.Tools::getValue('cufonconfig', (Configuration::get('CUFON_CONFIG'))).'</textarea>
				</div>
				<center><input type="submit" name="submitCufon" value="'.$this->l('Save').'" class="button" /></center>
				</div>
				
				<div class="tab-page" id="tab-page-2">
					<h2 class="tab">&nbsp;'.$this->l('Cufon Tips/Preview').'</h2>
		<script type="text/javascript" src="'._MODULE_DIR_.$this->name.'/js/cufon-yui.js"></script>
        <script type="text/javascript" src="'._MODULE_DIR_.$this->name.'/js/fonts/'.Tools::getValue('cufon', (Configuration::get('CUFON_FONT'))).'"></script>
		<script type="text/javascript">
				Cufon.replace("h1.cufonone", { color: "-linear-gradient(#000, #ff0000)" });
				Cufon.replace("h1.cufontwo", {	hover: "true" });
				Cufon.replace("h1.cufonthree", {textShadow: "1px 1px #000"});
		</script>
		<label>'.$this->l('Set gradient:').'</label>
		<div class="margin-form">
		<h1 class="cufonone">Aliquam sed lorem sem, sit amet porta mi. 0123456789</h1><br/>
		Cufon.replace("h1.cufonone", { color: "-linear-gradient(#000, #ff0000)" });
		</div>
		<label>'.$this->l('Enable hover:').'</label>
		<div class="margin-form">
		<style>
		h1.cufontwo a:hover{color: #ff0000;}
		h1.cufonone,h1.cufontwo,h1.cufonthree{color: #ff0000;font-size: 30px; margin:0px}
		</style>
		<h1 class="cufontwo"><a href="#">Aliquam sed lorem sem, sit amet porta mi. 0123456789</a></h1><br/>
		Cufon.replace("h1.cufontwo", {	hover: true });
		</div>
		<label>'.$this->l('Set Shadow:').'</label>
		<div class="margin-form">
		<h1 class="cufonthree">Aliquam sed lorem sem, sit amet porta mi. 0123456789</h1><br/>
		Cufon.replace("h1.cufonthree", {textShadow: "1px 1px #000"});
		</div><br/>
		<big>For more details visit <a href="https://github.com/sorccu/cufon/wiki/styling"><b>Cufon site</b>.</a></big>
		</div>
		</div>
		<script type="text/javascript">
			function loadTab(id){}
			setupAllTabs();
		</script>
		</fieldset></form><br/>
			<fieldset>
		<label>'.$this->l('Buy me a coffee:').'</label>
		<div class="margin-form">
		<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
		<input type="hidden" name="cmd" value="_s-xclick">
		<input type="hidden" name="hosted_button_id" value="WSF6LS9DUK4JJ">
		<input type="image" src="https://www.paypalobjects.com/en_US/i/btn/btn_donateCC_LG.gif" border="0" name="submit" alt="PayPal - The safer, easier way to pay online!">
		<img alt="" border="0" src="https://www.paypalobjects.com/en_US/i/scr/pixel.gif" width="1" height="1">
		</form>
		</div>
		</fieldset>
		';

	}


	public function hookHeader($params)
	{
		global $smarty;
		
		$smarty->assign(array(
			'cufon' => Configuration::get('CUFON_FONT'),
			'cufonconfig' => Configuration::get('CUFON_CONFIG')
		));

		return $this->display(__FILE__, 'header.tpl');
	}
}
