<?php
/*
* 2007-2011 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2011 PrestaShop SA
*  @version  Release: $Revision: 1.4 $
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_CAN_LOAD_FILES_'))
	exit;

class Lofuserinfo extends Module
{
	public function __construct()
	{
		$this->name = 'lofuserinfo';
		$this->tab = 'landofcoder';
		$this->version = 0.1;
		$this->author = 'LandOfCoder';
        $this->_params = array();

		parent::__construct();

		$this->displayName = $this->l('Lof User info block');
		$this->description = $this->l('Adds a block that displays information about the customer.');
	}

    public function install()
	{
        $blockcart      = Db::getInstance()->getValue('SELECT id_module FROM '._DB_PREFIX_.'module WHERE name="blockcart"',0);
        $rightColumn    = Db::getInstance()->getValue('SELECT id_hook FROM '._DB_PREFIX_.'hook WHERE name="rightColumn"',0);
        Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'hook_module WHERE id_module='.(int)($blockcart).' AND id_hook='.(int)($rightColumn));
        $blockuserinfo = Db::getInstance()->getValue('SELECT id_module FROM '._DB_PREFIX_.'module WHERE name="blockuserinfo"',0);
        $top         = Db::getInstance()->getValue('SELECT id_hook FROM '._DB_PREFIX_.'hook WHERE name="top"',0);
        $delte .=  'DELETE FROM '._DB_PREFIX_.'hook_module WHERE id_module='.(int)($blockuserinfo).' AND id_hook='.(int)($top);
        Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'hook_module WHERE id_module='.(int)($blockuserinfo).' AND id_hook='.(int)($top));
		$blockmyaccount = Db::getInstance()->getValue('SELECT id_module FROM '._DB_PREFIX_.'module WHERE name="blockmyaccount"',0);
        $top            = Db::getInstance()->getValue('SELECT id_hook FROM '._DB_PREFIX_.'hook WHERE name="top"',0);
        $delte .=  'DELETE FROM '._DB_PREFIX_.'hook_module WHERE id_module='.(int)($blockmyaccount).' AND id_hook='.(int)($top);
        Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'hook_module WHERE id_module='.(int)($blockmyaccount).' AND id_hook='.(int)($top));
		return (parent::install() AND $this->registerHook('top') AND $this->registerHook('header'));
	}

    public function uninstall()
	{
		if (!parent::uninstall())
			return false;
        $blockcart      = Db::getInstance()->getValue('SELECT id_module FROM '._DB_PREFIX_.'module WHERE name="blockcart"',0);
        $rightColumn    = Db::getInstance()->getValue('SELECT id_hook FROM '._DB_PREFIX_.'hook WHERE name="rightColumn"',0);
        Db::getInstance()->AutoExecute(_DB_PREFIX_.'hook_module', array('id_module' => $blockcart, 'id_hook' => $rightColumn, 'position'=>'1'), 'INSERT');
        $blockuserinfo = Db::getInstance()->getValue('SELECT id_module FROM '._DB_PREFIX_.'module WHERE name="blockuserinfo"',0);
        $top           = Db::getInstance()->getValue('SELECT id_hook FROM '._DB_PREFIX_.'hook WHERE name="top"',0);
        Db::getInstance()->AutoExecute(_DB_PREFIX_.'hook_module', array('id_module' => $blockuserinfo, 'id_hook' => $top, 'position'=>'5'), 'INSERT');
		$blockmyaccount = Db::getInstance()->getValue('SELECT id_module FROM '._DB_PREFIX_.'module WHERE name="blockmyaccount"',0);
        $top            = Db::getInstance()->getValue('SELECT id_hook FROM '._DB_PREFIX_.'hook WHERE name="top"',0);
        Db::getInstance()->AutoExecute(_DB_PREFIX_.'hook_module', array('id_module' => $blockmyaccount, 'id_hook' => $top, 'position'=>'4'), 'INSERT');
		return true;
	}

	/**
	* Returns module content for header
	*
	* @param array $params Parameters
	* @return string Content
	*/
	public function hookTop($params)
	{
		if (!$this->active)
			return;
		global $smarty, $cookie, $cart;
        $theme 			= Configuration::get($this->name.'_theme');
        if(!$theme) $theme = "default";

		$smarty->assign('order_page', strpos($_SERVER['PHP_SELF'], 'order') !== false);
		$this->smartyAssigns($smarty, $params);

		$smarty->assign(array(
			'simple_effect_on'=>  Configuration::get($this->name.'_simple_effect'),
			'cart' => $cart,
			'cart_qties' => $cart->nbProducts(),
			'logged' => $cookie->isLogged(),
			'customerName' => ($cookie->logged ? $cookie->customer_firstname.' '.$cookie->customer_lastname : false),
			'firstName' => ($cookie->logged ? $cookie->customer_firstname : false),
			'lastName' => ($cookie->logged ? $cookie->customer_lastname : false),
			'order_process' => Configuration::get('PS_ORDER_PROCESS_TYPE') ? 'order-opc' : 'order'
		));
        return $this->display(__FILE__, 'tmpl/'.$theme.'/default.tpl');
	}

	public function smartyAssigns(&$smarty, &$params)
	{
		global $errors, $cookie, $link;

		// Set currency
		if (!(int)($params['cart']->id_currency))
			$currency = new Currency((int)$params['cookie']->id_currency);
		else
			$currency = new Currency((int)$params['cart']->id_currency);
		if (!Validate::isLoadedObject($currency))
			$currency = new Currency((int)(Configuration::get('PS_CURRENCY_DEFAULT')));

		if ($params['cart']->id_customer)
		{
			$customer = new Customer((int)$params['cart']->id_customer);
			$taxCalculationMethod = Group::getPriceDisplayMethod((int)$customer->id_default_group);
		}
		else
			$taxCalculationMethod = Group::getDefaultPriceDisplayMethod();

		$useTax = !($taxCalculationMethod == PS_TAX_EXC);

		$products = $params['cart']->getProducts(true);
		$nbTotalProducts = 0;
		foreach ($products AS $product)
			$nbTotalProducts += (int)$product['cart_quantity'];

		$wrappingCost = (float)($params['cart']->getOrderTotal($useTax, Cart::ONLY_WRAPPING));
		//mostramos precio sin shipping
		//$totalToPay = $params['cart']->getOrderTotal($useTax,Cart::ONLY_PRODUCTS_WITHOUT_SHIPPING);
		$totalToPay = $params['cart']->getOrderTotal($useTax);


		if ($useTax AND Configuration::get('PS_TAX_DISPLAY') == 1)
		{
			$totalToPayWithoutTaxes = $params['cart']->getOrderTotal(false);
			$smarty->assign('tax_cost', Tools::displayPrice($totalToPay - $totalToPayWithoutTaxes, $currency));
		}

		$smarty->assign(array(
			'products' => $products,
			'customizedDatas' => Product::getAllCustomizedDatas((int)($params['cart']->id)),
			'CUSTOMIZE_FILE' => _CUSTOMIZE_FILE_,
			'CUSTOMIZE_TEXTFIELD' => _CUSTOMIZE_TEXTFIELD_,
			'discounts' => $params['cart']->getDiscounts(false, Tools::isSubmit('id_product')),
			'nb_total_products' => (int)($nbTotalProducts),
			'shipping_cost' => Tools::displayPrice($params['cart']->getOrderTotal($useTax, Cart::ONLY_SHIPPING), $currency),
			'show_wrapping' => $wrappingCost > 0 ? true : false,
			'show_tax' => (int)(Configuration::get('PS_TAX_DISPLAY')) == 1 ? true : false,
			'wrapping_cost' => Tools::displayPrice($wrappingCost, $currency),
			'product_total' => Tools::displayPrice($params['cart']->getOrderTotal($useTax, Cart::BOTH_WITHOUT_SHIPPING), $currency),
			'total' => Tools::displayPrice($totalToPay, $currency),
			'id_carrier' => (int)($params['cart']->id_carrier),
			'order_process' => Configuration::get('PS_ORDER_PROCESS_TYPE') ? 'order-opc' : 'order',
			'ajax_allowed' => (int)(Configuration::get('PS_BLOCK_CART_AJAX')) == 1 ? true : false
		));
		if (sizeof($errors))
			$smarty->assign('errors', $errors);
		if(isset($cookie->ajax_blockcart_display))
			$smarty->assign('colapseExpandStatus', $cookie->ajax_blockcart_display);
	}

	public function hookHeader($params)
	{
	    //add javascript
		Tools::addJS( ($this->_path).'assets/script.js', 'all');
        $theme 			= Configuration::get($this->name.'_theme');
        if(!$theme) $theme = "default";
        //add stylesheet
        if(_PS_VERSION_ <= "1.4"){
			if( $theme && $theme != -1 ){
				$cssjs = "<link href='"._MODULE_DIR_.$this->name."/tmpl/".$theme."/style.css' rel='stylesheet' type='text/css' media='all' />";
			}
            return $cssjs;
		}
		else {
			if( $theme && $theme != -1 ){
				Tools::addCSS(_MODULE_DIR_.$this->name."/tmpl/".$theme."/style.css", 'all');
			}
		}
	}

	public function getContent()
	{
		$output = '<h2>'.$this->displayName.'</h2>';
		if (Tools::isSubmit('submitBlockCart'))
		{
			$ajax = Tools::getValue('ajax');
			if ($ajax != 0 AND $ajax != 1)
				$output .= '<div class="alert error">'.$this->l('Ajax : Invalid choice.').'</div>';
			else
			{
                Configuration::updateValue($this->name.'_theme', Tools::getValue('theme'));
				Configuration::updateValue('PS_BLOCK_CART_AJAX', (int)($ajax));
				Configuration::updateValue($this->name.'_simple_effect', (int)( Tools::getValue('simple_effect')));
			}
			$output .= '<div class="conf confirm"><img src="../img/admin/ok.gif" alt="'.$this->l('Confirmation').'" />'.$this->l('Settings updated').'</div>';
		}
		return $output.$this->displayForm();
	}

    /**
    * Get list of sub folder's name
    */
	public function getFolderList( $path ) {
		$items = array();
		$handle = opendir($path);
		if (! $handle) {
			return $items;
		}
		while (false !== ($file = readdir($handle))) {
			if (is_dir($path . $file))
				$items[$file] = $file;
		}
		unset($items['.'], $items['..'], $items['.svn']);
		return $items;
	}

	public function displayForm()
	{
        $params = $this->_params;
        $themes = $this->getFolderList( dirname(__FILE__)."/tmpl/" );
        $theme  = Configuration::get($this->name.'_theme');
		$form = '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
				<legend><img src="'.$this->_path.'logo.gif" alt="" title="" />'.$this->l('Settings').'</legend>';
        $form .= '<label>'.$this->l('Select theme').'</label>
                  <div class="margin-form"><select name="theme">';
               foreach($themes as $item){
                    if($theme==$item){
                        $form .= '<option value="'.$item.'" selected="selected">'.$item.'</option>';
                    }else{
                        $form .= '<option value="'.$item.'">'.$item.'</option>';
                    }
               }
        $form .= '</select></div>';
		$form .= '<label>'.$this->l('Ajax cart').'</label>
				<div class="margin-form">
					<input type="radio" name="ajax" id="ajax_on" value="1" '.(Tools::getValue('ajax', Configuration::get('PS_BLOCK_CART_AJAX')) ? 'checked="checked" ' : '').'/>
					<label class="t" for="ajax_on"> <img src="../img/admin/enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
					<input type="radio" name="ajax" id="ajax_off" value="0" '.(!Tools::getValue('ajax', Configuration::get('PS_BLOCK_CART_AJAX')) ? 'checked="checked" ' : '').'/>
					<label class="t" for="ajax_off"> <img src="../img/admin/disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
					<p class="clear">'.$this->l('Activate AJAX mode for cart (compatible with the default theme)').'</p>
				</div>
				<label>'.$this->l('Advanded Effect').'</label>
				<div class="margin-form">
					<input type="radio" name="simple_effect" id="simple_effect_on" value="1" '.(Tools::getValue('simple_effect', Configuration::get('simple_effect')  ) ? 'checked="checked" ' : '').'/>
					<label class="t" for="simple_effect_on"> <img src="../img/admin/enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Effect').'" /></label>
					<input type="radio" name="simple_effect" id="simple_effect_off" value="0" '.(!Tools::getValue('simple_effect', Configuration::get('simple_effect') ) ? 'checked="checked" ' : '').'/>
					<label class="t" for="ajax_off"> <img src="../img/admin/disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
					<p class="clear">'.$this->l('(If you select Yes, When Added To Cart => A Modal Box will appear to showing Information of Recent Adding Product)').'</p>
				</div>


				<center><input type="submit" name="submitBlockCart" value="'.$this->l('Save').'" class="button" /></center>
			</fieldset>
			<br/>
			<fieldset><legend><img src="../img/admin/comment.gif" alt="" title="" />'.$this->l('Information').'</legend>
				<ul>
					 <li>+ <a target="_blank" href="http://landofcoder.com/prestashop/other/lof-user-infor-panel">'.$this->l("Detail Information").'</li>
					 <li>+ <a target="_blank" href="http://landofcoder.com/supports/forum.html?id=63">'.$this->l("Forum support").'</a></li>
					 <li>+ <a target="_blank" href="http://landofcoder.com/submit-request.html">'.$this->l('Customization/Technical Support Via Email').'</a></li>
					 <li>+ <a target="_blank" href="http://landofcoder.com/prestashop-guide-and-docs/prestashop-14x-lof-user-info-panel.html">'.$this->l('UserGuide ').'</a></li>
				</ul>
				<br />
				@copyright: <a href="http://landofcoder.com">LandOfCoder.com</a>
			</fieldset>
		</form>';
        return $form;
	}
	public function hookAjaxCall($params)
	{
		if (Configuration::get('PS_CATALOG_MODE'))
			return;

		global $smarty;
		$this->smartyAssigns($smarty, $params);
		return $this->display(__FILE__, 'blockcart-json.tpl');
	}
}