<?php
/**
  	Module Nivo Slider for PrestaShop by Paolo Rivera
    Copyright(C) 2011-2012  www.tiendasvirtuales.com.ve

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
    
    We thank NOT remove internal PAYPAL button for donations,
    I respect my work. Any donation received is welcome, the same
    encourage the development of new modules for free.
         
    Se agradece NO quitar el boton interno de PAYPAL  para DONATIVOS, 
    RESPETA mi trabajo. Todo donativo recibido es bienvenido, los mismos 
    impulsarán el desarrollo de nuevos modulos en forma gratuita.
**/

if (!defined('_CAN_LOAD_FILES_'))
	exit;

class nivoslider extends Module {
	
  protected $maxImageSize =  614400; /* (600 x 1024 =   614.400 bytes = 600KB)  */
  protected $error = false;
  
  public function __construct()
	{
	 	$this->name = 'nivoslider';
	 	if ($this->_isVerMenor())
	 	   $this->tab = 'Home';
	 	else
	 	{
       $this->tab = 'slideshows';
       $this->author = 'Paolo Rivera';
       $this->need_instance = 0;
    }    
	 	$this->version = '1.5';
	 	
	 	parent::__construct();

    $this->displayName = $this->l('Nivo Slider');
    $this->description = $this->l('Slide the images with choosen languages');
		$this->confirmUninstall = $this->l('Are you sure you want to delete all data ?');
 		$this->secure_key = Tools::encrypt($this->name);
 		$this->date_year = time();
    $this->path_myroot   = _PS_BASE_URL_.__PS_BASE_URI__; 
    $this->path_mymodule = _MODULE_DIR_.$this->name; 		
	}
	
	public function install()
	{
		if (!parent::install() OR !$this->registerHook('home'))
        return false; 
    
		$query = 'CREATE TABLE '._DB_PREFIX_.$this->name.' (
                 `id_image` int(2) NOT NULL AUTO_INCREMENT,
                 `id_lang` tinyint(2) unsigned NOT NULL,
                 `title` varchar(128) NOT NULL,
                 `url` varchar(255) NULL,
                 `description` varchar(255) NULL,
                 `new_window` tinyint(1) NOT NULL,
                 `image` varchar(64) NOT NULL,
                 `position` int(2) unsigned NOT NULL default \'0\', 
                 `show` tinyint(1) NOT NULL,
                  PRIMARY KEY(`id_image`)) ENGINE='._MYSQL_ENGINE_.' default CHARSET=utf8';
                  
	 	if (!Db::getInstance()->Execute($query))
	 		return false;
	 		
		if (!Configuration::updateValue($this->name.'_lang'	, intval(Configuration::get('PS_LANG_DEFAULT'))) OR
       !Configuration::updateValue($this->name.'_width'	, 540) OR
		   !Configuration::updateValue($this->name.'_height', 350) OR
       !Configuration::updateValue($this->name.'_margintop', 5) OR
       !Configuration::updateValue($this->name.'_marginbottom',5) OR
       !Configuration::updateValue($this->name.'_marginleft',0) OR
       !Configuration::updateValue($this->name.'_marginright',0) OR		   
       !Configuration::updateValue($this->name.'_backcolordiv', '#ffffff') OR     
       !Configuration::updateValue($this->name.'_slices'	, 9) OR
		   !Configuration::updateValue($this->name.'_animspeed', 500) OR
		   !Configuration::updateValue($this->name.'_startslide', 0) OR
       !Configuration::updateValue($this->name.'_directionnav', 'true') OR
       !Configuration::updateValue($this->name.'_directionnavhide', 'true') OR
		   !Configuration::updateValue($this->name.'_cn_nav', 'true') OR
		   !Configuration::updateValue($this->name.'_cn_navthumbs', 'false') OR
		   !Configuration::updateValue($this->name.'_cn_thumbsfromrel', 'false') OR
		   !Configuration::updateValue($this->name.'_manualadvance', 'false') OR
       !Configuration::updateValue($this->name.'_pausetime', 8500) OR
  	   !Configuration::updateValue($this->name.'_keyboardnav','true') OR
       !Configuration::updateValue($this->name.'_effect','random') OR
		   !Configuration::updateValue($this->name.'_pauseonhover', 'true') OR
		   !Configuration::updateValue($this->name.'_captionopacity', 0.8) OR
		   !Configuration::updateValue($this->name.'_headerjquery', 'true'))
		   return false;	 		
	 		
		return true;   
	}
	
	public function uninstall()
	{
		Configuration::deleteByName($this->name.'_lang');
    Configuration::deleteByName($this->name.'_width');
		Configuration::deleteByName($this->name.'_height');	
		Configuration::deleteByName($this->name.'_margintop');
		Configuration::deleteByName($this->name.'_marginbottom');
		Configuration::deleteByName($this->name.'_marginleft');
		Configuration::deleteByName($this->name.'_marginright');    	
		Configuration::deleteByName($this->name.'_backcolordiv');
    Configuration::deleteByName($this->name.'_slices');
		Configuration::deleteByName($this->name.'_animspeed');
		Configuration::deleteByName($this->name.'_startslide');
		Configuration::deleteByName($this->name.'_directionnav');
		Configuration::deleteByName($this->name.'_directionnavhide');
		Configuration::deleteByName($this->name.'_cn_nav');
		Configuration::deleteByName($this->name.'_cn_navthumbs');
		Configuration::deleteByName($this->name.'_cn_thumbsfromrel');
		Configuration::deleteByName($this->name.'_manualadvance');
		Configuration::deleteByName($this->name.'_pausetime');
		Configuration::deleteByName($this->name.'_keyboardnav');
		Configuration::deleteByName($this->name.'_effect');
		Configuration::deleteByName($this->name.'_pauseonhover');
		Configuration::deleteByName($this->name.'_captionopacity');
		Configuration::deleteByName($this->name.'_headerjquery');

    $this->all_deleteImg();
    
    if (!Db::getInstance()->Execute('DROP TABLE '._DB_PREFIX_.$this->name))
	 		return false;
		return parent::uninstall();
	}	

	function hookHome($params) 
  {
		global $cookie, $smarty;
		$query = 'SELECT `id_image`,`id_lang`,`title`,`url`,`description`,`new_window`,`image`,`position`,`show`  
              FROM '._DB_PREFIX_.$this->name.' WHERE `id_lang`='.intval($cookie->id_lang).' 
              AND `show` = 1 ORDER BY `position`';

		if (!$links = Db::getInstance()->ExecuteS($query))
				return false;

    $smarty->assign(array(
         'mylinks'          => $links,
         'width' 	          => Configuration::get($this->name.'_width'),
    		 'height'           => Configuration::get($this->name.'_height'),
    		 'margintop' 	      => Configuration::get($this->name.'_margintop'),
    		 'marginbottom'     => Configuration::get($this->name.'_marginbottom'),
    		 'marginleft'       => Configuration::get($this->name.'_marginleft'),
    		 'marginright' 	    => Configuration::get($this->name.'_marginright'),    		 
    		 'backcolordiv'     => Configuration::get($this->name.'_backcolordiv'),
         'slices' 	        => Configuration::get($this->name.'_slices'),
    		 'animspeed'        => Configuration::get($this->name.'_animspeed'),
    		 'startslide'       => Configuration::get($this->name.'_startslide'),
    		 'directionnav'     => Configuration::get($this->name.'_directionnav'),
    		 'directionnavhide' => Configuration::get($this->name.'_directionnavhide'),
    		 'cn_nav'           => Configuration::get($this->name.'_cn_nav'),
    		 'cn_navthumbs'     => Configuration::get($this->name.'_cn_navthumbs'),
    		 'cn_thumbsfromrel' => Configuration::get($this->name.'_cn_thumbsfromrel'),
    		 'manualadvance' 	  => Configuration::get($this->name.'_manualadvance'),
    		 'keyboardnav'      => Configuration::get($this->name.'_keyboardnav'),
    		 'pauseonhover'     => Configuration::get($this->name.'_pauseonhover'),
    		 'effect' 	        => Configuration::get($this->name.'_effect'),
    		 'pausetime' 	      => Configuration::get($this->name.'_pausetime'),
    		 'captionopacity'   => Configuration::get($this->name.'_captionopacity'),
    		 'headerjquery'     => Configuration::get($this->name.'_headerjquery')));

	  return $this->display(__FILE__, $this->name.'.tpl');
	}
  
  /**
  * Function hooks: additional footer,leftcolumn,rightcolumn,header,top.
  *   
  */    
  function hookFooter($params) {
		return $this->hookHome($params);
	}

	function hookLeftColumn($params) {
		return $this->hookHome($params);
	}	

	function hookRightColumn($params) {
		return $this->hookLeftColumn($params);
	}
	
	function hookHeader($params) {
		return $this->hookHome($params);
	}	

	function hookTop($params) {
		return $this->hookHome($params);
	}

	function hookHomeCenter($params) {
		return $this->hookHome($params);
	}

  /**
  * Function that returns the list of images stored in the database, 
  * if you can not find anything it returns false.
  *   
  * @return list or false.
  */	
	public function getLinks()
	{
    global $cookie;
		$result = array();
	 	
		$id_lang = Configuration::get($this->name.'_lang'); 
		if ($id_lang != "" ? $id_lang : $id_lang=0);
    /* Get id and url */  
		$query = 'SELECT `id_image`,`id_lang`,`title`,`url`,`description`,`new_window`,`image`,`position`,`show` FROM '._DB_PREFIX_.$this->name.' WHERE `id_lang`='.$id_lang.' ORDER BY `position`';

		if (!$links = Db::getInstance()->ExecuteS($query))
				return false;
		$i=0;
		foreach ($links AS $link) {
			$result[$i]['id_image'] = $link['id_image'];
			$result[$i]['title'] = $link['title'];
			$result[$i]['url'] = $link['url'];
			$result[$i]['description'] = $link['description'];
			$result[$i]['new_window'] = $link['new_window'];
			$result[$i]['image'] = $this->path_mymodule.'/img/'.$link['image'];
			$result[$i]['position'] = $link['position'];
			$result[$i]['show'] = $link['show'];
			$i++;
		}
		return $result;
	}
	
	public function addLink()
	{
		//global $cookie;
		$namefile="";
		$position = Db::getInstance()->getValue('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.' WHERE `id_lang`='.Configuration::get($this->name.'_lang'));
        
		/* upload the image */ 
		if (isset($_FILES['image']) AND isset($_FILES['image']['tmp_name']) AND !empty($_FILES['image']['tmp_name']))
		{
			/* 102400 bytes = 100KB */
      if ($error = checkImage($_FILES['image'], $this->maxImageSize))
      {
  				$this->_html .= $this->displayError($error);
  				return false;
  		}      
			if (!move_uploaded_file($_FILES['image']['tmp_name'], dirname(__FILE__).'/img/'.$_FILES['image']['name']))
			{
	  			$this->_html .= $this->displayError($this->l('Error move uploaded file'));
	  			return false;
		  }			
			$namefile = $_FILES['image']['name'];
			
  	 	/* Url registration */
  		if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.$this->name.' VALUES (\'\', \''.Configuration::get($this->name.'_lang').'\',\''.pSQL($_POST['title']).'\',\''.pSQL($_POST['url']).'\',\''.pSQL($_POST['description']).'\','.intval($new_window).',\''.$namefile.'\','.intval($position).', 1)') OR !$lastId = mysql_insert_id())
      {		
          $this->_html .= $this->displayError($this->l('Unable to add record to database.'));
          return false;
      }   
  		Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.$this->name.' SET image=\''.$namefile.'\' WHERE id_image='.intval($lastId));
  		return true;			
    }    
	}
	
	public function updateLink()
	{
	 	/* Url registration */ 
	 	if (!Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.$this->name.' SET `title`=\''.pSQL($_POST['title']).'\',`url`=\''.pSQL($_POST['url']).'\',`description`=\''.pSQL($_POST['description']).'\' WHERE `id_image`='.intval($_POST['id_image'])))
	 		return false;
	 	return true;
	}
	
	public function deleteLink($id_img)
	{
		$old_block = Db::getInstance()->ExecuteS('SELECT `position`,`id_lang` FROM '._DB_PREFIX_.$this->name.' WHERE `id_image` = '.intval($id_img).' AND `id_lang` = '.Configuration::get($this->name.'_lang'));
		$links = $this->getLinks();
    
	 	if ($links)
	 	{
		  foreach ($links AS $link)	{
			if (intval($link['id_image'])==intval($id_img))
			   {
	   	     $image = substr($link['image'],(strpos($link['image'],"/img/"))+5);
				   if (file_exists(_MODULE_DIR_.$this->name.'/img/'. $image)) 
					     $this->displayConfirmation('File deleted');
				   @unlink(dirname(__FILE__).'/img/'. $image);
			   }
      }
		}	
		
		if (sizeof($old_block))
		{
		  Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.$this->name.' SET `position` = (`position` - 1) WHERE `position` > '.$old_block[0]['position'].' AND `id_lang` = '.Configuration::get($this->name.'_lang'));
			Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.$this->name.' WHERE `id_image` = '.intval($id_img));
		}
		return true; 
	}
	
	public function all_deleteImg()
	{
    $query = 'SELECT * FROM '._DB_PREFIX_.$this->name.' ORDER BY `position`';
		if (!$links = Db::getInstance()->ExecuteS($query))
				return false;

	  foreach ($links AS $link)
	  {
 		   $id=intval($link['id_image']);
 	     $image = $link['image'];
		   if (file_exists(_MODULE_DIR_.$this->name.'/img/'. $image))
		      $this->displayConfirmation('File deleted');
 			 @unlink(dirname(__FILE__).'/img/'. $image);
       Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.$this->name.' WHERE `id_image` = '.intval($id));                       
    }
    return true; 
	}
	
	public function showLink()
	{
     $links = $this->getLinks();
	 	 if ($links)
	 	 {
        foreach ($links AS $link)
        {
			   if ($link['id_image']==$_GET['show'])
			   {
			      if ($link['show'])
               Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.$this->name.' SET `show`=0 WHERE `id_image`='.intval($link['id_image']));
            else
               Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.$this->name.' SET `show`=1 WHERE `id_image`='.intval($link['id_image']));
   
            return true;   
         }         
			  }
     }   	 	 
	}
	
	public function new_window()
	{
    $links = $this->getLinks();
	 	if ($links)
	 	{
      foreach ($links AS $link) {
			  if ($link['id_image']==$_GET['new_window'])
			  {
			      if ($link['new_window'])
               Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.$this->name.' SET `new_window`=0 WHERE `id_image`='.intval($link['id_image']));
            else
               Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.$this->name.' SET `new_window`=1 WHERE `id_image`='.intval($link['id_image']));
            return true;   
        }         
			}
    }   	 	 
	}	
  
  public function getContent()
	{
		$this->_html = '';
		/* update the content css */
		if (isset($_POST['submitSaveCSS']))
			  $this->_putContentCSS();
		if ($this->_postValidation())
        $this->_postProcess();
		$this->_html .= '<h2>'.$this->displayName.' v'.$this->version.'</h2>';
		if (Tools::isSubmit('submitEdiFilCss'))
			$this->_displayEditCSSForm();
		else
			$this->_displayForm();
		return $this->_html;
	}
  	
	private function _postValidation()
	{
		$errors = array();
    if (Tools::isSubmit('submitDelImages'))
		{
      $imgBoxes = Tools::getValue('imgBox');
			if (!is_array($imgBoxes))
			   $errors[] = $this->l('You must select at least one item to delete.');
    }
    
		if (Tools::isSubmit('submitAddImage'))
		{
       if (Tools::getValue('title') == '' OR empty($_FILES['image']['name']))
          $errors[] = $this->l('You must complete the following fields: title and image.');
     	 elseif (!preg_match('/.+\.(jpg|png|gif)$/',  strtolower($_FILES['image']['name'])))
          $errors[] = $this->l('The format should be only of type:    jpg, png, gif');           
       elseif (file_exists(_PS_MODULE_DIR_.$this->name.'/img/'.$_FILES['image']['name']))
          $errors[] = $this->l('The image file in the directory already exists');           
    }
     
		if (Tools::isSubmit('submitLinkUpdate'))
		{
       if (Tools::getValue('title') == '')
          $errors[] = $this->l('You must complete the following fields: title, url');
    }
    		
    if (Tools::isSubmit('submitSettings'))
		{
  		 if (!Validate::isUnsignedInt(Tools::getValue('width')))
  		 	  $errors[] = $this->l('Container width : invalid value, must be a unsigned number.');
  		 elseif (!Validate::isUnsignedInt(Tools::getValue('height')))
  		    $errors[] = $this->l('Container height : invalid value, must be a unsigned number.');
  		 elseif (!Validate::isUnsignedInt(Tools::getValue('margintop')))
  		   $errors[] = $this->l('Container margin top: invalid value, must be a unsigned number.');
  		 elseif (!Validate::isUnsignedInt(Tools::getValue('marginbottom')))
  		   $errors[] = $this->l('Container margin bottom : invalid value, must be a unsigned number.');
  		 elseif (!Validate::isUnsignedInt(Tools::getValue('marginleft')))
  		   $errors[] = $this->l('Container margin left : invalid value, must be a unsigned number.');
  		 elseif (!Validate::isUnsignedInt(Tools::getValue('marginright')))
  		   $errors[] = $this->l('Container margin right : invalid value, must be a unsigned number.');  		    
       elseif (!Validate::isColor(Tools::getValue('backcolordiv')) OR (substr(Tools::getValue('backcolordiv'),0,1) != '#') OR (strlen(Tools::getValue('backcolordiv')) != 7))            		 
          $errors[] = $this->l('Container Backcolor: invalid value, must be a color value in hexadecimal format.');       
       elseif (!Validate::isUnsignedInt(Tools::getValue('slices')))
  		 	  $errors[] = $this->l('Slices : invalid value, must be a unsigned number.');
  		 elseif (!Validate::isUnsignedInt(Tools::getValue('animspeed')))
  		    $errors[] = $this->l('AnimSpeed : invalid value, must be a unsigned number.');
  		 elseif (!Validate::isUnsignedInt(Tools::getValue('pausetime')))
  		    $errors[] = $this->l('PauseTime : invalid value, must be a unsigned number.');
  		 elseif (!Validate::isUnsignedInt(Tools::getValue('startslide')))
  		    $errors[] = $this->l('StartSlide : invalid value, must be a unsigned number.');
  		 elseif (!preg_match("/^([0-9\.])([^a-zA-Z])+$/",Tools::getValue('captionopacity')))
  		    $errors[] = $this->l('CaptionOpacity : invalid value, must be a unsigned number.');
    }
                     
		if (sizeof($errors))
		{
			$this->_html .= $this->displayError(implode('<br /> - ', $errors));
			return false;
		}
		return true;    

	}
      
	public function _postProcess()
	{
    /* Deleted all images */
    if (isset($_POST['submitDelImages']))
    {
        foreach($_POST['imgBox'] as $key => $value){
        $value=substr($value, 2);
        $this->deleteLink($value);
        }   
    		if (sizeof($_POST['imgBox'])>1)
     			$this->_html .= $this->displayConfirmation($this->l('The image files were deleted successfully selected'));
     		else
          $this->_html .= $this->displayConfirmation($this->l('The selected image file has been deleted successfully'));                    
    }
    /* Update file css (nivo-slider.css) */ 
    elseif (isset($_POST['submitEdiFilCss']))
    {
            /* revision aqui para prox version */
    }
    /* Refreshes the list of images */ 
    elseif (isset($_POST['submitRefreView']))
    {
       $this->_mainView();
    }     
    /* Save settings */
    elseif (isset($_POST['submitSettings']))
	  {
		    Configuration::updateValue($this->name.'_width'	         , Tools::getValue('width'));
		    Configuration::updateValue($this->name.'_height'	     , Tools::getValue('height'));
  			Configuration::updateValue($this->name.'_margintop'	     , Tools::getValue('margintop'));
  			Configuration::updateValue($this->name.'_marginbottom'   , Tools::getValue('marginbottom'));
  			Configuration::updateValue($this->name.'_marginleft'	   , Tools::getValue('marginleft'));
  			Configuration::updateValue($this->name.'_marginright'	   , Tools::getValue('marginright'));		    
        Configuration::updateValue($this->name.'_backcolordiv' , Tools::getValue('backcolordiv'));
		    Configuration::updateValue($this->name.'_slices'	         , Tools::getValue('slices'));
		    Configuration::updateValue($this->name.'_animspeed'	     , Tools::getValue('animspeed'));
		    Configuration::updateValue($this->name.'_startslide'     , Tools::getValue('startslide'));
		    Configuration::updateValue($this->name.'_directionnav' , (Tools::getValue('directionnav') ? 'true' : 'false'));
		    Configuration::updateValue($this->name.'_directionnavhide'	 , (Tools::getValue('directionnavhide') ? 'true' : 'false'));
		    Configuration::updateValue($this->name.'_cn_nav'	 , (Tools::getValue('cn_nav') ? 'true' : 'false'));
		    Configuration::updateValue($this->name.'_cn_navthumbs' , (Tools::getValue('cn_navthumbs') ? 'true' : 'false'));
		    Configuration::updateValue($this->name.'_cn_thumbsfromrel' , (Tools::getValue('cn_thumbsfromrel') ? 'true' : 'false'));
		    Configuration::updateValue($this->name.'_manualadvance'		 , (Tools::getValue('manualadvance') ? 'true' : 'false'));
		    Configuration::updateValue($this->name.'_pauseonhover'	 , (Tools::getValue('pauseonhover') ? 'true' : 'false'));
		    Configuration::updateValue($this->name.'_pausetime'	     , Tools::getValue('pausetime'));
		    Configuration::updateValue($this->name.'_keyboardnav'		 , (Tools::getValue('keyboardnav') ? 'true' : 'false'));
		    Configuration::updateValue($this->name.'_effect'	 , Tools::getValue('effect'));
		    Configuration::updateValue($this->name.'_captionopacity'	 , Tools::getValue('captionopacity'));
		    Configuration::updateValue($this->name.'_headerjquery'	 , (Tools::getValue('headerjquery') ? 'true' : 'false'));
 	      
  		  $this->_html .= $this->displayConfirmation($this->l('Settings updated'));
		}
    /* Update position image */
    elseif (Tools::isSubmit('id_image') AND Tools::isSubmit('way') AND Tools::isSubmit('position'))
		       	$this->changePosition();		  
    /* Delete a link image */
    elseif (isset($_GET['id_image']))
    {
        if (!is_numeric($_GET['id_image']) OR !$this->deleteLink($_GET['id_image']))
     	 	 	$this->_html .= $this->displayError($this->l('An error occurred during item deletion'));
     	 	else
          $this->_html .= $this->displayConfirmation($this->l('The imagen file has been deleted successfully'));
    }
    /* Show a link */
    elseif (isset($_GET['show']))
    {
        if (!is_numeric($_GET['show']) OR !$this->showLink())
     	 	 	$this->_html .= $this->displayError($this->l('An error occurred during item updated'));
     	 	else
          $this->_html .= $this->displayConfirmation($this->l('The item has been updated field show successfully'));
    }
    /* Open in new window ? */
    elseif (isset($_GET['new_window']))
    {
        if (!is_numeric($_GET['new_window']) OR !$this->new_window())
     	 	 	$this->_html .= $this->displayError($this->l('An error occurred during item updated'));
     	 	else
          $this->_html .= $this->displayConfirmation($this->l('The item has been updated field show successfully'));
    }     
    /* Change language (filtro de registros de imagen segun idioma) */
    elseif (isset($_GET['id_lang']))
    {
    	 	 	Configuration::updateValue($this->name.'_lang'	, intval($_GET['id_lang']));
    }
    /* Refreshes the list of images */ 
    elseif (isset($_POST['submitRefreView']))
    {
        $this->_mainView();
    }        
    /* Update a link */
    elseif (isset($_POST['submitLinkUpdate']))
    {
     	 	if (empty($_POST['title']))
     	 		$this->_html .= $this->displayError($this->l('You must complete the field: title.'));
	     	else
	     	 	if (empty($_POST['id_image']) OR !is_numeric($_POST['id_image']) OR !$this->updateLink())
	     	 		$this->_html .= $this->displayError($this->l('An error occured during item updating'));
	     	 	else
	     	 		$this->_html .= $this->displayConfirmation($this->l('The item has been updated successfully'));
    }
    /* Add a image */
    elseif (isset($_POST['submitAddImage']))
    { 
         if ($this->addLink())
     	  		$this->_html .= $this->displayConfirmation($this->l('The file image has been added successfully'));
    }
		/* move position image */ 
	  elseif (Tools::isSubmit('id_image') AND Tools::isSubmit('way') AND Tools::isSubmit('position'))
		       	$this->changePosition();		  
    /* Delete a link image */
    elseif (isset($_GET['id_image']))
    {
     	 	if (!is_numeric($_GET['id_image']) OR !$this->deleteLink($_GET['id_image']))
     	 	 	$this->_html .= $this->displayError($this->l('An error occurred during item deletion'));
     	 	else
     	 	 	$this->_html .= $this->displayConfirmation($this->l('The imagen file has been deleted successfully.'));
    }
  	/* Show a link*/
   	elseif (isset($_GET['show']))
   	{
    	 	if ($this->showLink())
     	 	 	$this->_html .= $this->displayConfirmation($this->l('The item has been updated field show successfully.'));
        unset($_GET['show']);     	 	 	
   	}
   	/* Change language (filtro de registros de imagen segun idioma) */
   	elseif (isset($_GET['id_lang']))
   	{
   	 	 	Configuration::updateValue($this->name.'_lang'	, intval($_GET['id_lang']));
   	}     	

  }  

  /**
  * Check file upload
  *
  * @param array $file Upload $_FILE value
  * @param integer $maxFileSize Maximum upload size
  */
  function checkFileUpload($file, $maxFileSize)
  {
    if ($file['size'] > $maxFileSize)
  		return Tools::displayError('File is too large').' ('.$this->size_file($file['size']).'). '.Tools::displayError('Maximum allowed:').' '.$this->size_file($maxFileSize);
  	if ($file['error'])
  		return Tools::displayError('Error while uploading file; please change your server\'s settings.').'('.Tools::displayError('Error code: ').$file['error'].')';
  	return false;
  }

  function size_file($size , $decimals = 2 )
  {
    $type = array(" Bytes", " KB", " MB", " GB", " TB"); 
    return round($size/pow(1024,($i = floor(log($size, 1024)))),$decimals ).$type[$i];
  } 

  private function _mainView()
  {
    if (!$this->_isVerMenor())
    {
       global $currentIndex, $cookie, $adminObj;
       Tools::redirectAdmin($currentIndex.'&configure='.$this->name.'&token='.$adminObj->token); 
    } else {
       Tools::redirectAdmin($currentIndex.'index.php?tab=AdminModules&configure='.$this->name.'&token='.$this->_myToken());
    }       
  }
  
	private function _displayEditCSSForm()
	{
		global $currentIndex, $cookie, $adminObj;

		$this->_html .= '
		<script type="text/javascript" src="'._PS_BASE_URL_.__PS_BASE_URI__.'modules/'.$this->name.'/'.$this->name.'.js"></script>';
		$this->_html .= '<form method="POST" action="'.$_SERVER['REQUEST_URI'].'">';
		$this->_html .= '
		<fieldset style="width: 900px;">';
		
		if (Tools::isSubmit('submitEdiFilCss'))
			$this->_html .= '<legend><img src="'._PS_ADMIN_IMG_.'edit.gif" alt="" /> '.$this->l('Edit File CSS').'</legend>';

    $this->_html .= '
				<div class="margin-form">';
				
		$this->_html .= '
					<div class="clear"></div>
				</div>
				<label>'.$this->l('Content').'</label>
				<div class="margin-form">';

         $existing_file = stripslashes($this->_getContentCSS() ) ;
					$this->_html .= '
						<textarea class="rte" cols="110" rows="20" id="content_css" name="content_css">' . $existing_file . '</textarea>';
				
				$this->_html .= '
					<div class="clear"></div>
				</div>
			<p class="center">
				<input type="submit" class="button" name="submitSaveCSS" value="'.$this->l('Save').'" />
				<a class="button" style="position:relative; padding:3px 3px 4px 3px; top:1px" href="'.$currentIndex.'&configure='.$this->name.'&token='.$adminObj->token.'">'.$this->l('Cancel').'</a>
			</p>
			</fieldset>
		</form>';    
    
		$this->_html .= '
		</fieldset>
		</form>';
	}
    
  private function _isVerMenor()
  {
    if (version_compare(Configuration::get('PS_VERSION_DB'), '1.4.0.0', '<')) 
       return true;
 		else 
       return false;
  }

  private function _myToken()
  {
    if ($this->_isVerMenor())
    {
        global $currentIndex, $cookie, $adminObj;
        $mytoken  = $adminObj->token;
 		} else {
        $mytoken  = Tools::getAdminTokenLite('AdminModules');
    }
    return $mytoken ;
  }      
  
  private function _getContentCSS()
  {
     $file = dirname(__FILE__).'/tools/css/nivo-slider.css';
     $cotents = @file_get_contents( $file ) ;
     return $cotents ;
  }      	

  private function _putContentCSS()
  {
     $contents = $_REQUEST['content_css'] ;
     $file = dirname(__FILE__).'/tools/css/nivo-slider.css';
     file_put_contents( $file, $contents ) ;
     $this->_html .= $this->displayConfirmation($this->l('File CSS updated'));
  }
  	
  public function _displayForm()
	{
    global $cookie;
	 	$languages = Language::getLanguages();
    	 	
 		$this->_html .='<script type="text/javascript" src="'.$this->_path.'tools/js/mod.'.$this->name.'.js"></script>';
 		$this->_html .='<script type="text/javascript" src="'.$this->_path.'tools/js/thickbox.js"></script>';
		$this->_html .='<link href="../css/thickbox.css" rel="stylesheet" type="text/css" media="screen" />';
		if ($this->_isVerMenor())
		{
       $this->_html .='<link href="'.$this->_path.'tools/css/'.$this->name.'-minor.css" rel="stylesheet" type="text/css" media="screen" />';
       $this->_html .='<script src="http://ajax.googleapis.com/ajax/libs/jquery/1.3.2/jquery.min.js" type="text/javascript"></script>';
    } else {
   		 $this->_html .='<script type="text/javascript" src="'.$this->_path.'tools/js/expand.js"></script>';
 	  	 $this->_html .='<script type="text/javascript" src="../js/jquery/jquery-colorpicker.js"></script>';
 		   $this->_html .='<script type="text/javascript" src="../js/jquery/jquery.tablednd_0_5.js"></script>';
       $this->_html .='<script type="text/javascript">MoveItemDnD(\''.$this->secure_key.'\');</script>';    
       $this->_html .='<link href="'.$this->_path.'tools/css/'.$this->name.'-higher.css" rel="stylesheet" type="text/css" media="screen" />';
    }
       
		$this->_html .='
		<div id="nivo">
        <h2 class="expand">
            <img src="' . __PS_BASE_URI__ . 'img/admin/picture.gif" alt="" title="" /> '.$this->l('Images').'      
        </h2>
        <div class="collapse">
           
           <fieldset>
    			    <legend><img src="' . __PS_BASE_URI__ . 'img/admin/picture.gif" alt="" title="" /> '.$this->l('Images').'</legend>
              <center>
              <table width="100%" class="cat_bar">
                  <th width="230px" style="text-align:left;"><span style="color:black;margin-left:5px;"><b>'.$this->l('Displaying image files for language:').'</b></span></th>
                  <th width="20px" style="text-align:left;"><img src="'._PS_IMG_.'l/'.Configuration::get($this->name.'_lang').'.jpg" alt="" title=""  /></th>
                  <th>
                      <form action="'.$_SERVER['REQUEST_URI'].'" method="post">
                      	<div style="float:right;margin-left:1px;margin-top:-3px;">	
                          <input type="hidden" name="id_item" value="1" />';
           				            $i = 0;
                              if (sizeof($languages) != 1)
                                  foreach ($languages AS $language) {
                                      $this->_html .='<img src="'._PS_IMG_.'l/'.(int)($language['id_lang']).'.jpg" onclick="linkLanguage('.(int)($language['id_lang']).')" alt="'.Tools::htmlentitiesUTF8($language['name']).'" style="cursor: pointer" />&nbsp;';
                        					    if ($i == 6)
                            							$this->_html .= '</div>'; $i++;
                                  }
                              $this->_html .= '
                      </form>
                      </th>
              </table>
              </center>';
              $this->_token();
              $this->_list();
              $this->_html .= '
           </fieldset>
           <div class="space"></div>
           <fieldset>
                <legend><img src="' . __PS_BASE_URI__ . 'img/admin/add.gif" alt="" title="" /> '.$this->l('Add image').'</legend>
           			<form action="'.$_SERVER['REQUEST_URI'].'" method="post" enctype="multipart/form-data">
               				<label>'.$this->l('Title:').'</label>
               				<div class="margin-form"><input type="text" name="title" id="title" size="97" value="'.(($this->error AND isset($_POST['title'])) ? $_POST['title'] : '').'" /><sup> *</sup></div>
               				<label>'.$this->l('Url:').'</label>
              				<div class="margin-form"><input type="text" name="url" id="url" size="97" value="'.(($this->error AND isset($_POST['url'])) ? $_POST['url'] : '').'" />
               				<p class="clear">'.$this->l('You must enter the link with "http://www", example: http://www.yourlink.com').'</p>
               				</div>
              				<label>'.$this->l('Description:').'</label>
              				<div class="margin-form"><textarea 
                        onKeyDown="contador(this.form.description,this.form.caracteres,255);"
                        onKeyUp="contador(this.form.description,this.form.caracteres,255);"
                        class="rte" cols="94" rows="3" id="description" name="description">' . (($this->error AND isset($_POST['description'])) ? $_POST['description'] : '') . '</textarea>
                        <p class="clear">'.$this->l('Description about the picture that shows.').'
                        <td>'.$this->l('Characters ').'</td>
                        <td><input type="text" name=caracteres size=2 value=255 disabled></td>
                        <td>'.$this->l(' lefts').'</td>
                        </p>
                      </div>               				
                      <label>'.$this->l('Image:').'</label>
                      <div class="margin-form"><input type="file" name="image" size="100" value="'.(($this->error AND isset($_POST['image'])) ? $_POST['image'] : '').'" /><sup> *</sup>
                      <p class="clear">'.$this->l('Upload only file .jpg, .gif, .png [maximum size: ').$this->maxImageSize.' bytes ('.$this->size_file($this->maxImageSize).')]</p>
                      </div>
              				<div class="margin-form">
               					<input type="hidden" name="id_image" id="id_image" value="'.($this->error AND isset($_POST['id_image']) ? $_POST['id_image'] : '').'" />
               					<input type="submit" class="button" name="submitAddImage" value="'.$this->l('Add new image').'" />
               					<input type="submit" class="button disable" name="submitLinkUpdate" value="'.$this->l('Edit this link').'" disabled="disabled" id="submitLinkUpdate" />
               				</div>
    			      <div class="small"><sup>*</sup> '.$this->l('Required field').'</div>
                </form>
           </fieldset>
        </div>
     
        <div class="space"></div>
     
        <h2 class="expand">
             <img src="' . __PS_BASE_URI__ . 'img/admin/cog.gif" alt="" title="" /> '.$this->l('Settings').'      
        </h2>
               
        <div class="collapse">
           	<form method="post" action="'.$_SERVER['REQUEST_URI'].'">
                <fieldset><legend>'.$this->l('Settings').'</legend>';

                      $this->_html .= '
                      <table width="100%" class="table settings" cellspacing="0" cellpadding="0">
                      		<thead>
                           <tr>
                      				<th width="20%" class="left"><b>'.$this->l('Parameter').'</b></th>
                      				<th width="68%" class="left"><b>'.$this->l('Description').'</b></th>
                      				<th width="12%" class="center"><b>'.$this->l('Value').'</b></th>
                      		 </tr>
                          </thead>
                        
                          <tbody>
                                <tr id="subtitle">
                                    <td id="point"><b>'.$this->l('Container:').'</b></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                 <tr>
                          					<td>'.$this->l('Container width:').'</td>
                          					<td>'.$this->l('Sets the pixel width of the container. (ex: 500).').'</td>
                          					<td><input class="nivoinput" type="text" name="width" id="width" value="'.Configuration::get($this->name.'_width').'"/>'.$this->l('px').'</td>
                                </tr>
                                <tr class="alt_row">
                          					<td>'.$this->l('Container height:').'</td>
                          					<td>'.$this->l('Set container height in pixel (ex : \'300\').').'</td>
                          					<td><input class="nivoinput" type="text" name="height" id="height" value="'.Configuration::get($this->name.'_height').'"/>'.$this->l('px').'</td>
                                </tr>
                                <tr>
                                  	<td>'.$this->l('Container margin top:').'</td>
                          					<td>'.$this->l('Specifies the margin of the head of the container in pixels.').'</td>
                          					<td><input class="nivoinput" type="text" name="margintop" id="margintop" value="'.Configuration::get($this->name.'_margintop').'"/>'.$this->l('px').'</td>
                                </tr>
                                <tr class="alt_row">
                          					<td>'.$this->l('Container margin bottom:').'</td>
                          					<td>'.$this->l('Specifies the margin of the foot of container in pixels.').'</td>
                          					<td><input class="nivoinput" type="text" name="marginbottom" id="marginbottom" value="'.Configuration::get($this->name.'_marginbottom').'"/>'.$this->l('px').'</td>
                                </tr>
                                <tr>
                          					<td>'.$this->l('Container margin left:').'</td>
                          					<td>'.$this->l('Specifies the margin of the left of container in pixels.').'</td>
                          					<td><input class="nivoinput" type="text" name="marginleft" id="marginleft" value="'.Configuration::get($this->name.'_marginleft').'"/>'.$this->l('px').'</td>
                                </tr>
                                <tr class="alt_row">
                          					<td>'.$this->l('Container margin right:').'</td>
                          					<td>'.$this->l('Specifies the margin of the rightt of container in pixels.').'</td>
                          					<td><input class="nivoinput" type="text" name="marginright" id="marginright" value="'.Configuration::get($this->name.'_marginright').'"/>'.$this->l('px').'</td>
                                </tr>
                                <tr>
                          					<td>'.$this->l('Container backcolor:').'</td>
                          					<td>'.$this->l('Backgroundcolor of the container, in HEX format. Example: #FFFFFF').'</td>
                                    <td><input type="color" data-hex="true" class="color nivoinput mColorPickerInput" name="backcolordiv" id="backcolordiv" value="'.Configuration::get($this->name.'_backcolordiv').'"/></td>                          					
                                </tr>

                                <tr id="subtitle">
                                    <td id="point"><b>'.$this->l('SliderShow:').'</b></td>
                                    <td></td>
                                    <td></td>
                                </tr>                                
                                          
                                <tr class="alt_row">
                          					<td>'.$this->l('Slices:').'</td>
                          					<td>'.$this->l('Set number of animated shorts or slices.').'</td>
                          					<td>
                                  	   <input class="nivoinput" type="text" name="slices" id="slices" size="6" value="'.Configuration::get($this->name.'_slices').'"/>
                                    </td>
                                </tr>
                                <tr>
                          					<td>'.$this->l('AnimSpeed:').'</td>
                          					<td>'.$this->l('Slide transition speed, (ex : 300).').'</td>
                          					<td><input class="nivoinput" type="text" name="animspeed" id="animspeed" size="6" value="'.Configuration::get($this->name.'_animspeed').'"/></td>
                                </tr>
                                <tr>
                          					<td>'.$this->l('PauseTime:').'</td>
                          					<td>'.$this->l('How long each slide will show.').'</td>
                          					<td><input class="nivoinput" type="text" name="pausetime" id="pausetime" size="6" value="'.Configuration::get($this->name.'_pausetime').'"/></td>                          					
                                </tr>
                                <tr>
                          					<td>'.$this->l('DirectionNav:').'</td>
                          					<td>'.$this->l('Next & Prev navigation.').'</td>
                          					<td>
                               					<input type="radio" name="directionnav" id="directionnav_on" value="1" '.(Configuration::get($this->name.'_directionnav') == "true" ? 'checked="checked" ' : '').'/>
                               					<label class="t" for="directionnav_on"> <img src="'._PS_ADMIN_IMG_.'enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
                               					<input type="radio" name="directionnav" id="directionnav_off" value="0" '.(Configuration::get($this->name.'_directionnav') == "false" ? 'checked="checked" ' : '').'/>
                               					<label class="t" for="directionnav_off"> <img src="'._PS_ADMIN_IMG_.'disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
                                    </td>                          					
                                </tr>
                                <tr>
                          					<td>'.$this->l('ControlNav:').'</td>
                          					<td>'.$this->l('1,2,3... navigation.').'</td>
                          					<td>
                               					<input type="radio" name="cn_nav" id="cn_nav_on" value="1" '.(Configuration::get($this->name.'_cn_nav') == "true" ? 'checked="checked" ' : '').'/>
                               					<label class="t" for="cn_nav_on"> <img src="'._PS_ADMIN_IMG_.'enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
                               					<input type="radio" name="cn_nav" id="cn_nav_off" value="0" '.(Configuration::get($this->name.'_cn_nav') == "false" ? 'checked="checked" ' : '').'/>
                               					<label class="t" for="cn_nav_off"> <img src="'._PS_ADMIN_IMG_.'disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
                                    </td>                          					
                                </tr>                                
                                <tr  class="alt_row">
                          					<td>'.$this->l('ControlNavThumbs:').'</td>
                          					<td>'.$this->l('Show menu in to movie.').'</td>
                          					<td>
                               					<input type="radio" name="cn_navthumbs" id="cn_navthumbs_on" value="1" '.(Configuration::get($this->name.'_cn_navthumbs') == "true" ? 'checked="checked" ' : '').'/>
                               					<label class="t" for="cn_navthumbs_on"> <img src="'._PS_ADMIN_IMG_.'enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
                               					<input type="radio" name="cn_navthumbs" id="cn_navthumbs_off" value="0" '.(Configuration::get($this->name.'_cn_navthumbs') == "false" ? 'checked="checked" ' : '').'/>
                               					<label class="t" for="cn_navthumbs_off"> <img src="'._PS_ADMIN_IMG_.'disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
                                    </td>                          					
                                </tr>
                                <tr>
                          					<td>'.$this->l('DirectionNavHide:').'</td>
                          					<td>'.$this->l('Hides the navigation bar.').'</td>
                          					<td>
                               					<input type="radio" name="directionnavhide" id="directionnavhide_on" value="1" '.(Configuration::get($this->name.'_directionnavhide') == "true" ? 'checked="checked" ' : '').'/>
                               					<label class="t" for="directionnavhide_on"> <img src="'._PS_ADMIN_IMG_.'enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
                               					<input type="radio" name="directionnavhide" id="directionnavhide_off" value="0" '.(Configuration::get($this->name.'_directionnavhide') == "false" ? 'checked="checked" ' : '').'/>
                               					<label class="t" for="directionnavhide_off"> <img src="'._PS_ADMIN_IMG_.'disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
                                    </td>                          					
                                </tr>                                
                                <tr class="alt_row">
                          					<td>'.$this->l('StartSlide:').'</td>
                          					<td>'.$this->l('Set starting Slide (0 index).').'</td>
                                    <td><input class="nivoinput" type="text" name="startslide" id="startslide" size="6" value="'.Configuration::get($this->name.'_startslide').'"/></td>                          					
                                </tr>
                                <tr>
                          					<td>'.$this->l('ControlNavThumbsFromRel:').'</td>
                          					<td>'.$this->l('Use image rel for thumbs.').'</td>
                          					<td>
                               					<input type="radio" name="cn_thumbsfromrel" id="cn_thumbsfromrel_on" value="1" '.(Configuration::get($this->name.'_cn_thumbsfromrel') == "true" ? 'checked="checked" ' : '').'/>
                               					<label class="t" for="cn_thumbsfromrel_on"> <img src="'._PS_ADMIN_IMG_.'enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
                               					<input type="radio" name="cn_thumbsfromrel" id="cn_thumbsfromrel_off" value="0" '.(Configuration::get($this->name.'_cn_thumbsfromrel') == "false" ? 'checked="checked" ' : '').'/>
                               					<label class="t" for="cn_thumbsfromrel_off"> <img src="'._PS_ADMIN_IMG_.'disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
                                    </td>                          					
                                </tr>                                
                                <tr class="alt_row">
                          					<td>'.$this->l('ManualAdvance:').'</td>
                          					<td>'.$this->l('Force manual transitions.').'</td>
                          					<td>
                               					<input type="radio" name="manualadvance" id="manualadvance_on" value="1" '.(Configuration::get($this->name.'_manualadvance') == "true" ? 'checked="checked" ' : '').'/>
                               					<label class="t" for="manualadvance_on"> <img src="'._PS_ADMIN_IMG_.'enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
                               					<input type="radio" name="manualadvance" id="manualadvance_off" value="0" '.(Configuration::get($this->name.'_manualadvance') == "false" ? 'checked="checked" ' : '').'/>
                               					<label class="t" for="manualadvance_off"> <img src="'._PS_ADMIN_IMG_.'disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
                                    </td>                          					
                                </tr>
                                <tr class="alt_row">
                          					<td>'.$this->l('PauseOnHover:').'</td>
                          					<td>'.$this->l('Stop animation while hovering.').'</td>
                          					<td>
                               					<input type="radio" name="pauseonhover" id="pauseonhover_on" value="1" '.(Configuration::get($this->name.'_pauseonhover') == "true" ? 'checked="checked" ' : '').'/>
                               					<label class="t" for="pauseonhover_on"> <img src="'._PS_ADMIN_IMG_.'enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
                               					<input type="radio" name="pauseonhover" id="pauseonhover_off" value="0" '.(Configuration::get($this->name.'_pauseonhover') == "false" ? 'checked="checked" ' : '').'/>
                               					<label class="t" for="pauseonhover_off"> <img src="'._PS_ADMIN_IMG_.'disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
                                    </td>                          					
                                </tr>
                                <tr class="alt_row">
                          					<td>'.$this->l('Effect:').'</td>
                          					<td>'.$this->l('Sets the effect to use between images. The default, random, randomly pick a effect. 
          To restrict to a certain effect, use these values: slidedown, slicedownleft, sliceup, sliceupleft, slideupdownleft, fold, fade o random.').'</td>
                          					<td>
                                        <select name="effect" id="effect" style="width:92px;">
                                        <option value="sliceDown" '.(Configuration::get($this->name.'_effect') == "sliceDown" ? 'selected="selected"' : '').'>'.$this->l('slicedown').'</option>
                                        <option value="sliceDownLeft" '.(Configuration::get($this->name.'_effect') == "sliceDownLeft" ? 'selected="selected"' : '').'>'.$this->l('slicedownleft').'</option>
                                        <option value="sliceUp" '.(Configuration::get($this->name.'_effect') == "sliceUp" ? 'selected="selected"' : '').'>'.$this->l('sliceup').'</option>
                                        <option value="sliceUpLeft" '.(Configuration::get($this->name.'_effect') == "sliceUpLeft" ? 'selected="selected"' : '').'>'.$this->l('sliceupleft').'</option>
                                        <option value="sliceUpDown" '.(Configuration::get($this->name.'_effect') == "sliceUpDown" ? 'selected="selected"' : '').'>'.$this->l('sliceupdown').'</option>
                                        <option value="sliceUpDownLeft" '.(Configuration::get($this->name.'_effect') == "sliceUpDownLeft" ? 'selected="selected"' : '').'>'.$this->l('sliceupdownleft').'</option>
                                        <option value="fold" '.(Configuration::get($this->name.'_effect') == "fold" ? 'selected="selected"' : '').'>'.$this->l('fold').'</option>
                                        <option value="fade" '.(Configuration::get($this->name.'_effect') == "fade" ? 'selected="selected"' : '').'>'.$this->l('fade').'</option>
                                        <option value="random" '.(Configuration::get($this->name.'_effect') == "random" ? 'selected="selected"' : '').'>'.$this->l('random').'</option>
                                        </select>                                                                                					
                                    </td>                          					
                                </tr>
                                <tr class="alt_row">
                          					<td>'.$this->l('KeyboardNav:').'</td>
                          					<td>'.$this->l('Use left & right arrows.').'</td>
                          					<td>
                               					<input type="radio" name="keyboardnav" id="keyboardnav_on" value="1" '.(Configuration::get($this->name.'_keyboardnav') == "true" ? 'checked="checked" ' : '').'/>
                               					<label class="t" for="keyboardnav_on"> <img src="'._PS_ADMIN_IMG_.'enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
                               					<input type="radio" name="keyboardnav" id="keyboardnav_off" value="0" '.(Configuration::get($this->name.'_keyboardnav') == "false" ? 'checked="checked" ' : '').'/>
                               					<label class="t" for="keyboardnav_off"> <img src="'._PS_ADMIN_IMG_.'disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
                                    </td>                          					
                                </tr>
                                <tr>
                          					<td>'.$this->l('CaptionOpacity:').'</td>
                          					<td>'.$this->l('Set the opacity of the image description.').'</td>
                          					<td><input class="nivoinput" type="text" name="captionopacity" id="captionopacity" size="6" value="'.Configuration::get($this->name.'_captionopacity').'"/></td>
                                </tr>
                           </tbody>
                      </table>
                      <div class="space"></div>
                      <div class="center"><input type="submit" class="button" name="submitSettings" value="'.$this->l('Update settings').'" /></div>  
                </fieldset>
  	        </form>
        </div>
        <div class="space"></div>
                          
        <h2 class="expand">
             <img src="' . __PS_BASE_URI__ . 'img/admin/help.png" alt="" title="" /> '.$this->l('Help').'      
        </h2>
        <div class="collapse">
             <fieldset>
              				<legend>'.$this->l('Help').'</legend>
                      <p>'.$this->l('Nivo Slider allows you to upload images and then display them as a slide using jQuery as the interface. Do not just show only 4 or 5 pictures, use all the required display. You can reorder or disable an image at any time.').'</p>
                      <p>'.$this->l('The module Nivo Slider for PrestaShop is completely free to use.').'</p>
                      <p>'.$this->l('Versión:').$this->version.' <a href="http://www.tiendasvirtuales.com.ve/site/nivo-slider-para-prestashop/">'.$this->l('Check for update').'</a></p>
             </fieldset>
             <div class="space"></div>
        </div>
     
        <h2 class="expand">
            <img src="'._PS_ADMIN_IMG_.'information.png" alt="" class="middle" />'.$this->l('About').'      
        </h2>
        <div class="collapse">';
               $this->_html .= '
               <fieldset>
              				<legend>'.$this->l('About').'</legend>
                      <p>'.$this->l('Nivo Slider module for Prestashop by Paolo Rivera is based on Nivo Slider of Dev7studios.com. Nivo Slider is the Most Awesome jQuery Image Slider out. And it’s free !.').'</p>
                      <p><a href="http://www.tiendasvirtuales.com.ve">Paolo Rivera</a> | <a href="http://nivo.dev7studios.com/">Dev7studios.com</a></p>
               </fieldset>
               <div class="space"></div>
        </div>
      
        <h2 class="expand">
            <img src="'._PS_ADMIN_IMG_.'gold.gif" alt="" class="middle" />'.$this->l('Make a donation').'      
        </h2>
        <div class="collapse">
             <fieldset>
             <legend>'.$this->l('Make a donation').'</legend>
             <form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_blank" style="margin-top:1em">    
                      <input type="hidden" name="cmd" value="_s-xclick">
                      <input type="hidden" name="hosted_button_id" value="87M94LYQB9L56">
                      
                      <p>'.$this->l('You can make a donation to support the author of Nivo Slider for PrestaShop. ').'</p>
                      <p>'.$this->l('If you think that the module developed is of great help, then you can donate dollars 1, 3 or 5 to take a coffee or a Pepsi. Any donation received is welcome, they encourage the development of new modules for free.').'</p>                    
                      <p><a href="http://www.tiendasvirtuales.com.ve">&copy'.date("Y",$this->date_year).' - www.tiendasvirtuales.com.ve | Paolo Rivera  </a></p>                    
                      <center>
                      <input type="submit" name="submit" value="'.$this->l('Donate').'" class="button" style="font-size:1em; padding:5px 30px 5px 30px;" />
                      </center>
              </form>
              </fieldset>      
        </div>
    </div>               
        <script type="text/javascript">
        <!--//--><![CDATA[//><!--
        $(function() {
            // --- first section initially expanded:
            $("h2.expand").toggler({initShow: "div.collapse:first",speed: 300});
            // --- Other options:
            //$("h2.expand").toggler({method: "toggle", speed: 0});
            //$("h2.expand").toggler({method: "toggle"});
            //$("h2.expand").toggler({speed: "fast"});
            //$("h2.expand").toggler({method: "fadeToggle"});
            //$("h2.expand").toggler({method: "slideFadeToggle"});    
            //$("#content").expandAll({trigger: "h2.expand", ref: "div.demo",  speed: 300, oneSwitch: false});
            //$("#content").expandAll({trigger: "h2.expand", ref: "div.demo", localLinks: "p.top a"});
        });
        //--><!]]>
        </script>
        <script>
        function contador (campo, cuentacampo, limite) {
          if (campo.value.length > limite) campo.value = campo.value.substring(0, limite);
          else cuentacampo.value = limite - campo.value.length;
        }             
        </script>
        ';            		
	}
	
	public function _token()
	{
	 	global $currentIndex, $cookie, $adminObj;
		$this->_html .= '
    			<script type="text/javascript">
		    	var currentUrl = \''.$currentIndex.'&configure='.$this->name.'\';
				  var token=\''.$adminObj->token.'\';';
 		$this->_html .= '</script>';
	}
         	

 	public function _list()
	{
	 	global $currentIndex, $cookie;
    $links = $this->getLinks();
    $languages = Language::getLanguages();

	 	if ($links)	{
	 		$this->_html .= '
			<script type="text/javascript">
			  var links = new Array();';
    	foreach ($links AS $link)	{
   			$this->_html .= 'links['.$link['id_image'].'] = new Array(\''.$link['title'].'\',\''.addslashes($link['url']).'\',\''.$link['description'].'\',\''.$link['new_window'].'\',\''.$link['image'].'\',\''.$link['position'].'\',\''.$link['show'].'\'';
   			$this->_html .= ');';
    	}
    	$this->_html .= '</script>';
	 	}
	 	 
    $this->_html .= '<table width="100%" class="table" cellspacing="0" cellpadding="0" id="table_images" class="tableDnD">
		<thead>
      <tr class="nodrag nodrop">
        <th width="2%"><input type="checkbox" name="checkme" class="noborder" onclick="checkAllBoxesOne($(this).attr(\'checked\'))" /></th>
				<th width="2%"><b>'.$this->l('ID').'</b></th>
				<th width="10%" class="left"><b>'.$this->l('Title').'</b></th>
				<th width="24%" class="left"><b>'.$this->l('Url').'</b></th>
				<th width="32%" class="left"><b>'.$this->l('Description').'</b></th>
				<th width="4%" class="left"><b>'.$this->l('New window').'</b></th>
				<th width="10%" class="left"><b>'.$this->l('Photo').'</b></th>
				<th width="3%" class="center"><b>'.$this->l('Position').'</b></th>
				<th width="3%" class="center"><b>'.$this->l('Show').'</b></th>
				<th width="10%" class="center"><b>'.$this->l('Actions').'</b></th>
			</tr>
      </thead>
      <tbody>
      ';
    	
		if (!$links)
		{
			$this->_html .= '
			<tr>
				<td colspan="7">'.$this->l('There are no links yet').'</td>
			</tr>';
		} else {
		  $this->_html .= '
      <form action="'.$_SERVER['REQUEST_URI'].'" method="post" enctype="multipart/form-data">';
			$irow = 0;
      foreach ($links AS $link)
			{
				$this->_html .= '
				
				<tr id="tr_1_'.$link['id_image'].'_'.$link['position'].'" '.($irow++ % 2 ? 'class="alt_row"' : '').'>
								<td width="3%"><input type="checkbox" name="imgBox[]" class="imgBox" id="1_'.$link['id_image'].'" value="1_'.$link['id_image'].'" '.
				(in_array('1_'.$link['id_image'], $link ) ? ' checked="checked"' : '').' /></td>

					<td>'.$link['id_image'].'</td>
					<td>'.$link['title'].'</td>
					<td>'.$link['url'].'&nbsp</td>';
				  
          if ($this->_isVerMenor())
					{
              $this->_html .= '<td>'.Tools::truncate($link['description'],25).'&nbsp</td>';
          } else {
              $this->_html .= '<td>'.Tools::truncate($link['description'],40).'&nbsp</td>';                        
          }
          					
          if ($link['new_window'])
       		   $this->_html .= '<td align="center"><img src="'.$this->path_mymodule.'/tools/img/checked.gif" alt="" title="'.$this->l('New window').'" onclick="linkNewWindow('.$link['id_image'].')" style="cursor:pointer" /></td>';
          else
             $this->_html .= '<td align="center"><img src="'.$this->path_mymodule.'/tools/img/notchecked.gif" alt="" title="'.$this->l('Same window').'" onclick="linkNewWindow('.$link['id_image'].')" style="cursor:pointer" /></td>';
          					
					$this->_html .= '<td><a href="'.$link['image'].'" title="'.$link['title'].'" class="thickbox"><img src="'.$link['image'].'" alt="'.$link['title'].'" title="'.$link['title'].'" with="40px" height="25px"/></td>';
          					
					if ($this->_isVerMenor())
					   $this->_html .= '<td class="center pointer">';
					else
             $this->_html .= '<td class="center pointer dragHandle">';
					
					$this->_html .='
    				 <a'.(($link['position'] == (sizeof($links) - 1) OR sizeof($links) == 1) ? ' style="display: none;"' : '').' href="'.$currentIndex.'&configure='.$this->name.'&id_image='.$link['id_image'].'&way=1&position='.(int)($link['position'] + 1).'&token='.$this->_myToken().'">
						 <img src="'._PS_ADMIN_IMG_.'down.gif" alt="'.$this->l('Down').'" title="'.$this->l('Down').'" /></a>
						 <a'.($link['position'] == 0 ? ' style="display: none;"' : '').' href="'.$currentIndex.'&configure='.$this->name.'&id_image='.$link['id_image'].'&way=0&position='.(int)($link['position'] - 1).'&token='.$this->_myToken().'">
						 <img src="'._PS_ADMIN_IMG_.'up.gif" alt="'.$this->l('Up').'" title="'.$this->l('Up').'" /></a>
					</td>';
					
          if ($link['show'])
       		$this->_html .= '<td align="center"><img src="'._PS_ADMIN_IMG_.'enabled.gif" alt="" title="'.$this->l('Enabled').'" onclick="linkShow('.$link['id_image'].')" style="cursor:pointer" /></td>';
          else
          $this->_html .= '<td align="center"><img src="'._PS_ADMIN_IMG_.'disabled.gif" alt="" title="'.$this->l('Disabled').'" onclick="linkShow('.$link['id_image'].')" style="cursor:pointer" /></td>';

          $this->_html .= '<td align="center">
						<img src="'._PS_ADMIN_IMG_.'edit.gif" alt="" title="'.$this->l('Edit').'" onclick="linkEdition('.$link['id_image'].')" style="cursor: pointer" />
						<img src="'._PS_ADMIN_IMG_.'delete.gif" alt="" title="'.$this->l('Delete').'" onclick="linkDeletion('.$link['id_image'].');" style="cursor: pointer" />

					</td>
				</tr>';
			}
    }  	
		$this->_html .= '</tbody></table>';

    if ($links)
    {
        $this->_html .= '
        <p>
           <input type="submit" class="button" name="submitDelImages" onclick="return confirm(\'¿ Borrar los elementos seleccionados ?\');" value="'.$this->l('Delete selected').'" id="submitDelImages" />
           <input type="submit" class="button" name="submitEdiFilCss" onclick="return confirm(\''.$this->l('Edit CSS file ?').'\');" value="'.$this->l('Edit File CSS').'" id="submitEdiFilCss" />
           <input type="submit" class="button" name="submitRefreView" onclick="return confirm('.$this->l('Refresh View').');" value="'.$this->l('Refresh View').'" id="submitRefreView" />
        </p>';
    }

    $this->_html .= '</form>';

	}
  
  /**
  * Function that changes the position of the images. 
  * returns false on failure.
  *    
  */
	public function changePosition()
	{
		$this->_html .= 'position change!';
		if (Tools::getValue('way') == 0)
		{
			if (Db::getInstance()->Execute('
			UPDATE '._DB_PREFIX_.$this->name.' SET `position` = '.((int)(Tools::getValue('position')) + 1).'
			WHERE `position` = '.((int)(Tools::getValue('position')))))
				Db::getInstance()->Execute('
				UPDATE '._DB_PREFIX_.$this->name.' SET `position` = '.((int)(Tools::getValue('position'))).'
				WHERE `id_image` = '.(int)(Tools::getValue('id_image')));
		}
		elseif (Tools::getValue('way') == 1)
		{
			if(Db::getInstance()->Execute('
			UPDATE '._DB_PREFIX_.$this->name.' SET `position` = '.((int)(Tools::getValue('position')) - 1).'
			WHERE `position` = '.((int)(Tools::getValue('position')))))
				Db::getInstance()->Execute('
				UPDATE '._DB_PREFIX_.$this->name.' SET `position` = '.((int)(Tools::getValue('position'))).'
				WHERE `id_image` = '.(int)(Tools::getValue('id_image')));
		}
    $this->_mainView();
	}

}
?>