<?php

class ProductNextPrevNC extends Module
{
	function __construct()
	{
		$this->name = 'productnextprevnc';
		$this->tab = 'Nethercott Constructions';
		$this->version = '1.1';

		parent::__construct(); // The parent construct is required for translations

		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Product Next/Previous Links');
		$this->description = $this->l('Adds links on the product page that go to the next and previous products in the category');
	}

	function install()
	{
		if (!parent::install() OR !$this->registerHook('header') OR !$this->registerHook('productFooter'))
			return false;
		return true;
	}
	
	public function hookHeader($params)
	{
		return $this->display(__FILE__, 'productnextprevnc-header.tpl');
	}
	
	public function hookProductFooter($params)
	{
		global $smarty, $cookie, $link;
		
		$id_product = intval(Tools::getValue('id_product'));
		$product = new Product($id_product, true, intval($cookie->id_lang));
		$category = new Category($product->id_category_default, intval($cookie->id_lang));
		$cat_products = $category->getProducts(intval($cookie->id_lang), 1, 1000000);
		
		$previous = NULL;
		$next = NULL;
		
		for ($i = 0; $i < sizeof($cat_products); $i++)
		{
			if ($cat_products[$i]['id_product'] == $id_product)
			{
				if ($i > 0)
				{
					$cat_product = new Product($cat_products[$i - 1]['id_product'], intval($cookie->id_lang));
					$previous = $link->getProductLink($cat_products[$i - 1]['id_product'], $cat_product->link_rewrite[intval($cookie->id_lang)], $category->link_rewrite, $cat_product->ean13);
				}
				
				if ($i < sizeof($cat_products) - 1)
				{
					$cat_product = new Product($cat_products[$i + 1]['id_product'], intval($cookie->id_lang));
					$next = $link->getProductLink($cat_products[$i + 1]['id_product'], $cat_product->link_rewrite[intval($cookie->id_lang)], $category->link_rewrite, $cat_product->ean13);;
				}
			}
		}
		
		$smarty->assign(array('previous' => $previous, 'next' => $next));			
		
		return $this->display(__FILE__, 'productnextprevnc.tpl');
	}
	
	public function hookProductActions($params)
	{
		return $this->hookProductFooter($params);
	}	
}