<?php

if (!defined('_PS_VERSION_'))
	exit;

class socialshare extends Module {

	/*
		Configuration values written :
		SocialShare_TWITTER_en			: enable or not twitter share plugin
		SocialShare_FACEBOOK_en			: enable or not fb share plugin
		SocialShare_PINTEREST_en		: enable or not pinterest plugin
		SocialShare_GPLUS_en			: enable or not Google+ plugin

		SocialShare_TWITTER_men			: enable or not twitter media box
		SocialShare_FACEBOOK_men		: enable or not fb media box

		SocialShare_TWITTER_VIA 		: twitter username to use to display on the media box
		SocialShare_FACEBOOK_SEND 		: fb send enabled or not
		SocialShare_TWITTER_USERNAME 	: twitter username to use to display on the media box
		SocialShare_FACEBOOK_PAGE 		: fb page uri for media plugin
	*/

	public function __construct() {
		$this->name    = 'socialshare';
		$this->version = '1.0';
		$this->tab 	   = 'front_office_features';
		$this->author  = 'Paul da Silva';
		$this->module_key = '883bb945d9bc582fcdb07638f43bde95';

		parent::__construct();

		$this->displayName = $this->l('Social Share');
		$this->description = $this->l('This module enables you to add sharing plugins to your product page');
	}

	public function install() {
		if(!parent::install()
			|| !$this->registerHook('extraRight')
			|| !$this->registerHook('rightcolumn')
			|| !$this->createConf()
			|| !$this->installModuleTab('AdminSocial', array(Configuration::get('PS_LANG_DEFAULT') => 'Social'), 'AdminCatalog'))
			return false;
		return true;
	}

	public function uninstall() {
		if(!parent::uninstall()
			|| !$this->uninstallModuleTab('AdminSocial')
			|| !$this->removeConf())
			return false;
		return true;
	}

	public function getContent() {
		global $cookie;
		$tab = 'AdminSocial';
		$token = Tools::getAdminToken($tab.(int)(Tab::getIdFromClassName($tab)) . (int)($cookie->id_employee));
		Tools::redirectAdmin('index.php?tab=' . $tab . '&token=' . $token);
	}

	public function hookleftcolumn() {
		return $this->hookrightcolumn();
	}

	public function hookrightcolumn() {
		global $smarty;

		$smarty->assign(array(
			'twitterm'          => Configuration::get('SocialShare_TWITTER_men'),
			'facebookm'         => Configuration::get('SocialShare_FACEBOOK_men'),
			'facebook_page'     => Configuration::get('SocialShare_FACEBOOK_PAGE'),
			'twitter_username'  => Configuration::get('SocialShare_TWITTER_USERNAME'),
		));

		return $this->display(__FILE__, 'socialshare_column.tpl');
	}

	public function hookextraRight() {
		global $smarty;

		$images = Product::getCover(Tools::getValue('id_product'));

		//tech
		$smarty->assign('id_product', Tools::getValue('id_product'));
		$smarty->assign('id_product_image', $images['id_image']);

		//twitter
		if(Configuration::get('SocialShare_TWITTER_en') && Configuration::get('SocialShare_TWITTER_VIA'))
			$smarty->assign('twitter_via', Configuration::get('SocialShare_TWITTER_VIA'));

		//facebook
		if(Configuration::get('SocialShare_FACEBOOK_en') && Configuration::get('SocialShare_FACEBOOK_SEND'))
			$smarty->assign('facebook_send', Configuration::get('SocialShare_FACEBOOK_SEND'));

		$smarty->assign(array(
			'twitter'    => Configuration::get('SocialShare_TWITTER_en'),
			'facebook'   => Configuration::get('SocialShare_FACEBOOK_en'),
			'pinterest'  => Configuration::get('SocialShare_PINTEREST_en'),
			'google'     => Configuration::get('SocialShare_GPLUS_en'),
		));

		return $this->display(__FILE__, 'socialshare.tpl');
	}

	private function installModuleTab($tabClass, $tabName, $classTabParent) {
		$tab = new Tab();
		$tab->name = $tabName;
		$tab->class_name = $tabClass;
		$tab->module = $this->name;
		$tab->id_parent = Tab::getIdFromClassName($classTabParent);

		if(!$tab->save())
			return false;
		return true;
	}

	private function uninstallModuleTab($tabClass) {
		$idTab = Tab::getIdFromClassName($tabClass);
		if($idTab != 0) {
			$tab = new Tab($idTab);
			$tab->delete();
			return true;
		}
		return false;
	}

	private function createConf() {
		$activated = array(
			'SocialShare_TWITTER_en'    	=> true,
			'SocialShare_FACEBOOK_en'   	=> true,
			'SocialShare_PINTEREST_en'  	=> true,
			'SocialShare_GPLUS_en'      	=> true,
			'SocialShare_TWITTER_VIA'   	=> '',
			'SocialShare_FACEBOOK_SEND' 	=> true,
			'SocialShare_TWITTER_men'       => false,
			'SocialShare_FACEBOOK_men'      => false,
			'SocialShare_TWITTER_USERNAME'  => '',
			'SocialShare_FACEBOOK_PAGE'     => '',
		);

		foreach($activated as $k=>$v)
			Configuration::updateValue($k, $v);

		return true;
	}

	private function removeConf() {
		$activated = array(
			'SocialShare_TWITTER_en',
			'SocialShare_FACEBOOK_en',
			'SocialShare_PINTEREST_en',
			'SocialShare_GPLUS_en',
			'SocialShare_TWITTER_VIA',
			'SocialShare_FACEBOOK_SEND',
			'SocialShare_TWITTER_men',
			'SocialShare_FACEBOOK_men',
			'SocialShare_TWITTER_USERNAME',
			'SocialShare_FACEBOOK_PAGE',
		);

		foreach($activated as $v)
			Configuration::deleteByKey($v);

		return true;
	}
	
}

