{*
* 2007-2011 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2011 PrestaShop SA
*  @version  Release: $Revision: 1.4 $
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

{if isset($products)}
	<!-- Products list -->
    {assign var='liHeight' value=350}
	{assign var='nbItemsPerLine' value=5}
	{assign var='nbLi' value=$products|@count}
	{assign var='nbLines' value=($nbLi/$nbItemsPerLine)|ceil}
	{assign var='ulHeight' value=$nbLines*$liHeight}
    {foreach from=$currencies key=k item=f_currency}
      {if $id_currency_cookie == $f_currency.id_currency}
		{assign var='symabolCurrency' value=$f_currency.sign}
	  {/if}
    {/foreach}
	<ul id="product_list" style="{$ulHeight}px"  >
	{foreach from=$products item=product name=products}
		<li class="ajax_block_product {if $smarty.foreach.products.first}first_item{elseif $smarty.foreach.products.last}last_item{else}item{/if} {if $smarty.foreach.products.iteration%$nbItemsPerLine == 0}last_item_of_line{elseif $smarty.foreach.products.iteration%$nbItemsPerLine == 1}clear{/if} {if $smarty.foreach.products.iteration > ($smarty.foreach.products.total - ($smarty.foreach.products.total % $nbItemsPerLine))}last_line{/if}" style="position:relative; border:1px solid #eee;">

				<a href="{$product.link|escape:'htmlall':'UTF-8'}" class="product_img_link" title="{$product.name|escape:'htmlall':'UTF-8'}"><img src="{$link->getImageLink($product.link_rewrite, $product.id_image, 'home')}" alt="{$product.legend|escape:'htmlall':'UTF-8'}" {if isset($homeSize)} width="{$homeSize.width}" height="{$homeSize.height}"{/if} />

        </a>




			<div class="right_block">
        <div>
           <h3 style="background:none;"><a href="{$product.link|escape:'htmlall':'UTF-8'}">{$product.name|truncate:28:'...'|escape:'htmlall':'UTF-8'}</a></h3>
        </div>

                <div class="left_price">
            	   {if isset($product.on_sale) && $product.on_sale && isset($product.show_price) && $product.show_price && !$PS_CATALOG_MODE}<span class="on_sale">{l s='On sale!'}</span>
				   {elseif isset($product.reduction) && $product.reduction && isset($product.show_price) && $product.show_price && !$PS_CATALOG_MODE}<span class="discount">{l s='Reduced price!'}</span>{/if}
				   {if isset($product.online_only) && $product.online_only}<span class="online_only">{l s='Online only!'}</span>{/if}
                        {if $product.specific_prices.reduction_type == 'percentage'}
                            <p class="discount">{$product.specific_prices.reduction*100}{l s='% off' mod='homefeatured'}</p>
                        {/if}
                        {if  $product.specific_prices.reduction_type == 'amount'}
                            <p class="discount">{$product.specific_prices.reduction|string_format:"%.2f"} {$symabolCurrency}</p>
                        {/if}
                </div>

                <div class="price_container">
          	     {if (!$PS_CATALOG_MODE AND ((isset($product.show_price) && $product.show_price) || (isset($product.available_for_order) && $product.available_for_order)))}
                  {if $product.reduction}
                    <span class="old_price">
                         {displayWtPrice p=$product.price_without_reduction}
                    </span>
                    <p class="price">
                        {if !$priceDisplay}{convertPrice price=$product.price}{else}{convertPrice price=$product.price_tax_exc}{/if}
                    </p>
                  {else}
                    <p class="price">
                        {if !$priceDisplay}{convertPrice price=$product.price}{else}{convertPrice price=$product.price_tax_exc}{/if}
                    </p>
                  {/if}
                {/if}
                </div>
         		<div style="clear:both;"></div>

			</div>
		</li>
	{/foreach}
	</ul>
	<!-- /Products list -->
{/if}
<div style="clear:both; height:11px;"></div>